/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.gui.main.Launcher;

public class DebugJTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String PATH = "src/main/java/net/nooj4nlp/gui/components/";
    private Color backgroundColor;
    private JLabel plusImage;
    private JLabel minusImage;

    public DebugJTreeRenderer(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        try {
            BufferedImage plus = ImageIO.read(new File("src/main/java/net/nooj4nlp/gui/components/plus.png"));
            BufferedImage minus = ImageIO.read(new File("src/main/java/net/nooj4nlp/gui/components/minus.png"));
            this.plusImage = new JLabel(new ImageIcon(plus));
            this.minusImage = new JLabel(new ImageIcon(minus));
            this.plusImage.setOpaque(false);
            this.minusImage.setOpaque(false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while loading image icons!", "NooJ Error!", 0);
            this.plusImage = new JLabel();
            this.minusImage = new JLabel();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!leaf) {
            JPanel panel = new JPanel();
            String text = (String)((DefaultMutableTreeNode)value).getUserObject();
            JLabel textLabel = new JLabel(text);
            panel.setLayout((LayoutManager)new MigLayout("ins 0", "[16][]", "[]"));
            panel.add((Component)(expanded ? this.minusImage : this.plusImage), "cell 0 0, alignx center, aligny center");
            panel.add((Component)textLabel, "cell 1 0, alignx center, aligny center");
            panel.setBackground(this.backgroundColor);
            return panel;
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

